<?php

#################################################### Include config and functions files ################################################

require_once 'config.php';

require_once 'functions.php';



########################################### Check if reserve exist in url and is not empty #############################################

if(!isset($_GET['reserve']) || empty($_GET['reserve']))

{

	$_SESSION['error'] = 'The tracking code seems to be wrong. Please try again in a few moments or contact us !'; r('customer-area/');

}



###################################### Get tracking details and property details from database #########################################

else

{

	$_GET['reserve'] = preg_replace('/\D/', '', $_GET['reserve']);

	try

	{

		$q = $pdo->prepare("SELECT tracking.*,properties.*,agents.*,owners.* FROM tracking,properties,agents,owners WHERE tracking_code = ? AND tracking_property = property_id AND property_agent = agent_id AND property_detail_owner = owner_id");

		$q ->bindParam(1, $_GET['reserve'], PDO::PARAM_STR);

		$q ->execute();

	}

	catch (PDOException $e) {echo 'Error !'.$e; exit();}

	if($q->rowCount() != 1)

	{

		$_SESSION['error'] = 'The tracking code seems to be wrong. Please try again in a few moments or contact us !'; r('customer-area/');

	}

	$t = $q->fetch(PDO::FETCH_ASSOC);

	$t['owner'] = unserialize($t['owner']);

	$t['tracking_language'] = explode(',',$t['tracking_language']);

	$t['property_detail_address'] = '';

	if($t['property_detail_city'] != '')

	{

		$t['property_detail_address'] .= $t['property_detail_city'];

		if($t['property_detail_post_code'] != '')

		{

			$t['property_detail_address'] .= ' '.$t['property_detail_post_code'];

		}

	}

	elseif($t['property_detail_post_code'] != '')

	{

		$t['property_detail_address'] .= $t['property_detail_post_code'];

	}

	if($t['property_detail_street'] != '')

	{

		if($t['property_detail_address'] != '')

		{

			$t['property_detail_address'] .= ', ';

		}

		$t['property_detail_address'] .= $t['property_detail_street'];

		if($t['property_detail_street_nr'] != '')

		{

			$t['property_detail_address'] .= ' '.$t['property_detail_street_nr'];

		}

	}

}



############################################################ TRACK LANGUAGE ############################################################

$languages = array(

	'en' => 'English',

	'de' => 'German',

	'es' => 'Spanish',

	'fr' => 'French',

	'fr' => 'France',

	'it' => 'Italian',

);

foreach($languages as $language_key => $language)

{

	if(!in_array($language_key,$t['tracking_language']))

	{

		unset($languages[$language_key]);

	}

}

if(isset($_GET['language']) && in_array($_GET['language'],array_keys($languages)))

{

	$_SESSION['lang'] = strtolower($_GET['language']);

}

if(!isset($_SESSION['lang'])) {$_SESSION['lang'] = 'en';}

$s_tracking_translations = unserialize($s['s_tracking_translations']);

$tracking = $s_tracking_translations[$_SESSION['lang']];



foreach($tracking as $key => $tracking_field)

{

	if(empty($tracking_field)) { $tracking[$key] = $s_tracking_translations['en'][$key]; }

}



$find = array('website_business_u','website_business','website_address','website_domain','website_phone','website_fax','website_logo','tracking_first_name','tracking_last_name','tracking_address','tracking_company','tracking_city','tracking_postal_code','tracking_country','tracking_phone','tracking_email','property_detail_address','property_detail_rooms','property_detail_size','property_detail_earnest_procent','property_detail_earnest_deposit','property_price','property_rent','property_deposit','owner_first_name','owner_second_name','owner_last_name','owner_passport_code','owner_passport_signature');



$replace = array(strtoupper($s['s_website_business']),$s['s_website_business'],replace_settings(nl2br(str_replace('|','<br /><br />',$s['s_address']))),$domain,$s['s_phone'],$s['s_fax'],$logo,$t['tracking_first_name'],$t['tracking_last_name'],$t['tracking_address'],$t['tracking_company'],$t['tracking_city'],$t['tracking_postal_code'],$t['tracking_country'],$t['tracking_phone'],$t['tracking_email'],$t['property_detail_address'],$t['property_detail_rooms'],$t['property_detail_size'],$t['property_detail_earnest_procent'],$t['property_detail_earnest_deposit'],$t['property_price'],$t['property_rent'],$t['property_deposit'],$t['owner']['passport_first_name'],@$t['owner']['passport_second_name'],$t['owner']['passport_last_name'],$t['owner']['passport_code'],'<img src="/t/'.$t['owner_id'].'_signature.png" style="" />');

$tracking['agreement_rent'] = str_replace($find,$replace,$tracking['agreement_rent']);

$tracking['agreement_sale'] = str_replace($find,$replace,$tracking['agreement_sale']);

$tracking['agreement_owner'] = str_replace($find,$replace,$tracking['agreement_owner']);



if(isset($_GET['view']) && isset($_GET['part']))

{

	if($_GET['part'] == 1)

	{

		$tracking['agreement_rent'] = str_replace(' class="part2"',' style="display:none"',$tracking['agreement_rent']);

		$tracking['agreement_sale'] = str_replace(' class="part2"',' style="display:none"',$tracking['agreement_sale']);

		$tracking['agreement_rent'] = str_replace(' class="part3"',' style="display:none"',$tracking['agreement_rent']);

		$tracking['agreement_sale'] = str_replace(' class="part3"',' style="display:none"',$tracking['agreement_sale']);

	}

	elseif($_GET['part'] == 2)

	{

		$tracking['agreement_rent'] = str_replace(' class="part1"',' style="display:none"',$tracking['agreement_rent']);

		$tracking['agreement_sale'] = str_replace(' class="part1"',' style="display:none"',$tracking['agreement_sale']);

		$tracking['agreement_rent'] = str_replace(' class="part3"',' style="display:none"',$tracking['agreement_rent']);

		$tracking['agreement_sale'] = str_replace(' class="part3"',' style="display:none"',$tracking['agreement_sale']);

	}

	elseif($_GET['part'] == 3)

	{

		$tracking['agreement_rent'] = str_replace(' class="part1"',' style="display:none"',$tracking['agreement_rent']);

		$tracking['agreement_sale'] = str_replace(' class="part1"',' style="display:none"',$tracking['agreement_sale']);

		$tracking['agreement_rent'] = str_replace(' class="part2"',' style="display:none"',$tracking['agreement_rent']);

		$tracking['agreement_sale'] = str_replace(' class="part2"',' style="display:none"',$tracking['agreement_sale']);

	}

	elseif($_GET['part'] == 4 && isset($_GET['print']))

	{

		$tracking['agreement_owner'] = str_replace(' class="part2"',' style="display:none"',$tracking['agreement_owner']);

	}

	elseif($_GET['part'] == 5 && isset($_GET['print']))

	{

		$tracking['agreement_owner'] = str_replace(' class="part1"',' style="display:none"',$tracking['agreement_owner']);

	}

}



############################################## Download Agreement and Earnest Money Deposit ############################################

if(isset($_GET['download'],$_GET['type']))

{

	// Download function

	function download($path,$file,$type)

	{

		if(!file_exists($path.$file)) 

		{

			$_SESSION['error'] = 'The agreement and Earnest Money Deposit is not processed yet for download. Please try again in a few moments or <a href="../contact-us/">contact us</a> !';

			header('Location: ../agreement.php?reserve='.$_GET['reserve']); exit();

		}

		if($type == 'img')

		{

			header("Content-Type: application/octet-stream");

			header("Content-Length: " . filesize($path.$file));

			header('Content-Disposition: attachment; filename='.$file);

			readfile($path.$file);

		}

		elseif($type == 'pdf')

		{

			header("Content-disposition: attachment; filename=".$file);

			header("Content-type: application/pdf");

			readfile($path.$file);

		}

		elseif($type == 'zip')

		{

			header('Location: '.$path.$file);

		}

	}

	

	if($_GET['download'] == 'agreement')

	{

		if($_GET['part'] == 4)

		{

			if($_GET['type'] == 'image')

			{

				download('t/','Exclusivity-contract-'.$_GET['reserve'].'-part-1.png','img');

			}

			elseif($_GET['type'] == 'pdf')

			{

				download('t/','Exclusivity-contract-'.$_GET['reserve'].'-part-1.pdf','pdf');

			}

		}

		elseif($_GET['part'] == 5)

		{

			if($_GET['type'] == 'image')

			{

				download('t/','Exclusivity-contract-'.$_GET['reserve'].'-part-2.png','img');

			}

			elseif($_GET['type'] == 'pdf')

			{

				download('t/','Exclusivity-contract-'.$_GET['reserve'].'-part-2.pdf','pdf');

			}

		}

		else

		{

			if($_GET['type'] == 'image')

			{

				download('t/','Agreement-'.$_GET['reserve'].'-part-'.$_GET['part'].'.png','img');

			}

			elseif($_GET['type'] == 'pdf')

			{

				download('t/','Agreement-'.$_GET['reserve'].'-part-'.$_GET['part'].'.pdf','pdf');

			}

		}

	}

	elseif($_GET['download'] == 'emd')

	{

		if($_GET['type'] == 'image')

		{

			download('t/','Earnest-Money-Deposit-details-'.$_GET['reserve'].'.png','img');

		}

		elseif($_GET['type'] == 'pdf')

		{

			download('t/','Earnest-Money-Deposit-details-'.$_GET['reserve'].'.pdf','pdf');

		}

	}

	elseif($_GET['download'] == 'agreement-and-emd' && $_GET['type'] == 'archive')

	{

		download('t/','Agreement-and-EMD-details-'.$_GET['reserve'].'.zip','zip');

	}

}



function compress($source, $destination, $quality) {



    $info = getimagesize($source);



    if ($info['mime'] == 'image/jpeg') 

        $image = imagecreatefromjpeg($source);



    elseif ($info['mime'] == 'image/gif') 

        $image = imagecreatefromgif($source);



    elseif ($info['mime'] == 'image/png') 

        $image = imagecreatefrompng($source);



    imagejpeg($image, $destination, $quality);



    return $destination;

}

?>

<!DOCTYPE html>

<html lang="en-US">

<head>

<meta http-equiv="content-type" content="text/html; charset=UTF-8">

<title><?php echo $tracking['track_page_title'] ?></title>

<meta http-equiv="X-UA-Compatible" content="IE=edge">

<link rel="stylesheet" type="text/css" href="font.css" />

<link rel="stylesheet" type="text/css" href="../f/style.css">

<link href="<?php echo $s['s_favicon']; ?>" rel="shortcut icon" />

<script src="../f/jquery.min.js"></script>

<script src="../f/jquery-ui.min.js"></script>

<script src="../f/jquery.rotate-1.0.1.min.js"></script>

<script>

function slide(button)

{

	$('td.slider div.slide_img').hide();

	$('td.slider div.slide_img_' + button).fadeIn();

	$('td.slider div.slide_buttons span').removeAttr('style');

	$('td.slider div.slide_buttons span.slide_button_' + button).css('background','#911414');

}



$( document ).ready(function(){

	$('#act b').on('click',function() {

		$('#emd').slideDown(200,function(){$('#act').fadeOut(300);});

	});

	

	$('.read-more').click(function() {

		if($('td.agent p').css('max-height') == '109px')

		{

			$(this).html('<img src="/f/arrow-up.png" /><?php echo $tracking['track_agent_read_less'] ?>');

			$('td.agent p').animate({"max-height":'600'}, 500 );

		}

		else

		{

			$(this).html('<img src="/f/arrow-down.png" /><?php echo $tracking['track_agent_read_more'] ?>');

			$('td.agent p').animate({"max-height":109}, 500 );

		}

	});

	

	$('td.slider div.reserved').css('margin-top',($('td.slider').height() - 240)  / 2);

	$('td.slider div.reserved p').jqrotate(-24);

	$('td.slider div.slide_img').css('height',$('td.slider').height() - 2);

	$('td.slider div.slide_buttons').css('margin-top',$('td.slider').height() - 26);

	$('td.slider').mouseover(function() {

		$('td.slider div.reserved').hide();

	});

	$('td.slider').mouseout(function() {

		$('td.slider div.reserved').show();

	});

/*PRINT*/});

</script>

</head>

<body>



	<?php if(!isset($_GET['view'])) { ?>

		<div id="emd">

			<div class="download none" onclick="$(this).fadeOut()">

				<div class="r7" onmouseout="$('div.download').attr('onclick','$(this).fadeOut()')" onmouseover="$('div.download').attr('onclick',false)">

					<h4><?php echo $tracking['track_download_agreement_title'] ?><a href="#" onclick="$('div.download').fadeOut(); return false;"><img src="f/close.png" /></a></h4>

				

					<p><?php echo $tracking['track_download_agreement_image_title'] ?>

					<a href="agreement.php?reserve=<?php echo $_GET['reserve']; ?>&download=agreement&type=image&part=3" class="r5"><?php echo $tracking['track_download_part'] ?> 3</a>

					<a href="agreement.php?reserve=<?php echo $_GET['reserve']; ?>&download=agreement&type=image&part=2" class="r5"><?php echo $tracking['track_download_part'] ?> 2</a>

					<a href="agreement.php?reserve=<?php echo $_GET['reserve']; ?>&download=agreement&type=image&part=1" class="r5"><?php echo $tracking['track_download_part'] ?> 1</a>

					</p>

				

					<p><?php echo $tracking['track_download_agreement_pdf_title'] ?>

					<a href="agreement.php?reserve=<?php echo $_GET['reserve']; ?>&download=agreement&type=pdf&part=3" class="r5"><?php echo $tracking['track_download_part'] ?> 3</a>

					<a href="agreement.php?reserve=<?php echo $_GET['reserve']; ?>&download=agreement&type=pdf&part=2" class="r5"><?php echo $tracking['track_download_part'] ?> 2</a>

					<a href="agreement.php?reserve=<?php echo $_GET['reserve']; ?>&download=agreement&type=pdf&part=1" class="r5"><?php echo $tracking['track_download_part'] ?> 1</a>

					</p>

				

					<?php if($t['property_type'] == 0) { ?>

					<p><?php echo $tracking['track_download_owner_agreement_image_title'] ?>

					<a href="agreement.php?reserve=<?php echo $_GET['reserve']; ?>&download=agreement&type=image&part=5" class="r5"><?php echo $tracking['track_download_part'] ?> 2</a>

					<a href="agreement.php?reserve=<?php echo $_GET['reserve']; ?>&download=agreement&type=image&part=4" class="r5"><?php echo $tracking['track_download_part'] ?> 1</a>

					</p>

				

					<p><?php echo $tracking['track_download_owner_agreement_pdf_title'] ?>

					<a href="agreement.php?reserve=<?php echo $_GET['reserve']; ?>&download=agreement&type=pdf&part=5" class="r5"><?php echo $tracking['track_download_part'] ?> 2</a>

					<a href="agreement.php?reserve=<?php echo $_GET['reserve']; ?>&download=agreement&type=pdf&part=4" class="r5"><?php echo $tracking['track_download_part'] ?> 1</a>

					</p>

					<?php } ?>

					

					<p><?php echo $tracking['track_download_earnest_title'] ?>

					<a href="agreement.php?reserve=<?php echo $_GET['reserve']; ?>&download=emd&type=pdf" class="r5"><?php echo $tracking['track_download_as_pdf'] ?></a>

					<a href="agreement.php?reserve=<?php echo $_GET['reserve']; ?>&download=emd&type=image" class="r5"><?php echo $tracking['track_download_as_image'] ?></a>

					</p>

				

					<p><?php echo $tracking['track_download_agreement_and_earnest_title'] ?>

					<a href="agreement.php?reserve=<?php echo $_GET['reserve']; ?>&download=agreement-and-emd&type=archive" class="r5"><?php echo $tracking['track_download_archive'] ?></a>

					</p>

				</div>

			</div>

			

			<div class="emd r7">

			

				<table cellspacing="0" cellpadding="0" class="emd-top r5">

					<tr>

						<td valign="middle" class="p5" style="padding-bottom:0px;">

							<?php echo $logo ?>

						</td>

						<td valign="top" align="right" class="p5">

							<?php

							if($s['s_account_type'] == 'cc')

							{

								echo '<b style="margin-top:24px;">Reservation: T'.$_GET['reserve'].' - '.date("d/m/o",(14).$_GET['reserve']).'</b>';

							}

							else

							{

								if($t['property_type'] == 0 && $t['tracking_owner_passport'] == 1 && $t['tracking_owner_agreement'] == 1)

								{

									echo '<a href="#" class="button r4 download" onclick="'."$('div.download').fadeIn(); return false;".'">'.$tracking['track_link_download'].'</a>';

								}

								else

								{

									echo '<b>'.date("d/m/o",(1400000000 + $_GET['reserve'])).'</b>';

								}

								if(count($languages) > 1)

								{

									echo '<div class="langs">';

									foreach($languages as $lang_key => $lang_name)

									{

										echo '<a href="?reserve='.$_GET['reserve'].'&amp;language='.$lang_key.'" onclick="'."$('.loader').show();".'" title="'.$lang_name.'"><img src="/f/lang_'.$lang_key.'.png" /></a>';

									}

									echo '</div>';

								}

								echo '<br />';

								if($t['tracking_owner_passport'] == 1)

								{

									echo '<a href="#" onclick="'."$('#act').fadeIn(300,function(){jQuery('#emd').slideUp();}).find('div').append(Array(50).join('<span>www.".$domain."</span>')).find('span').jqrotate(-20); return false;".'" class="button r4 act">'.$tracking['track_link_act'].'</a>';

								}

								echo '<a href="agreement.php?reserve='.$_GET['reserve'].'&view" target="_blank" class="button r4 view">'.$tracking['track_link_view'].'</a>';

								if($t['property_type'] == 0 && $t['tracking_owner_agreement'] == 1)

								{

									echo '<a href="agreement.php?reserve='.$_GET['reserve'].'&view&amp;part=4" target="_blank" class="button r4 view">'.$tracking['track_link_owner_view'].'</a>';

								}

								if($t['tracking_owner_passport'] == 0 || $t['tracking_owner_agreement'] == 0)

								{

									echo '<a href="#" class="button r4 download" onclick="'."$('div.download').fadeIn(); return false;".'">'.$tracking['track_link_download'].'</a>';

								}

							}

							?>

						</td>

					</tr>

				</table>

				

				<?php

					if(!empty($_SESSION['error'])) {echo '<p class="error r3">'.$_SESSION['error'].'<span onclick="'."$('p.error').fadeOut();".'"></span></p>'; unset($_SESSION['error']);}

				?>

				<br />

				

				<table cellspacing="0" cellpadding="0" class="emd-content">

					<tr>

						<td class="b0 p8"><b><?php echo $tracking['track_property_details'] ?></b></td>

						<td class="b0 p8" align="right"><?php

							if($s['s_account_type'] != 'cc')

							{

								echo '<b style="margin-top:24px;">'.$tracking['track_number'].' '.$_GET['reserve'].' - '.date("d/m/o",(14).$_GET['reserve']).'</b>';

							}

						?></td>

					</tr>

					<tr>

						<td valign="top" class="p8 slider">

							<?php

								if(!isset($_GET['print']))

								{

									echo '<div class="reserved"><p>'.$t['tracking_first_name'].' '.$t['tracking_last_name'].'</p></div>';

								}

								$i = 0;

								foreach(range(1,100) as $img)

								{

									$img = 'p/'.$t['tracking_property'].'_'.$img.'.png';

									if(file_exists($img) && $i < 14)

									{

										$i++;

										if(!isset($_GET['print']) || (isset($_GET['print']) && $i < 2))

										{

											echo '<div class="slide_img slide_img_'.$i; if($i != 1) {echo ' none';} echo '" style="background:url(../'; if(isset($_GET['try_again'])) {echo compress($img, str_replace('.png','.jpg',$img),8);} else {echo $img;} echo ') no-repeat center center; background-size:cover; -moz-background-size:cover;"></div>';

										}

									}

								}

								if(!isset($_GET['print']))

								{

									echo '<div class="slide_buttons">';

									foreach(range(1,$i) as $button)

									{

										echo '<span onclick="slide('.$button.')" class="r10 slide_button_'.$button.'"'; if($button == 1) { echo ' style="background:#911414;"';} echo '></span>';

									}

									echo '</div>';

								}

							?>

						</td>

						<td valign="top" class="p8 details">

							<?php

							$details = array('property_detail_address','property_detail_owner','property_detail_size','property_detail_rooms','property_detail_floor','property_detail_bedrooms','property_detail_bathrooms','property_detail_year_built','property_detail_balcony_terrace','property_detail_garden','property_detail_elevator','property_detail_garage','property_detail_furniture');

							$i = 0;

							foreach($details as $detail)

							{

								if(!empty($t[$detail]))

								{

									$i++;

									if($detail == 'property_detail_size')

									{

										$t[$detail] = $t[$detail].' m<sup>2</sup>';

									}

									elseif($detail == 'property_detail_owner')

									{

										$t[$detail] = '';

										if($t['tracking_owner_passport'] == 1)

										{

											$t[$detail] .= '<a href="#" onclick="'."$('a.act').trigger('click'); return false;".'">';

										}

										

										$t[$detail] .= $t['owner']['passport_first_name'];

										if(isset($t['owner']['passport_second_name']) && !empty($t['owner']['passport_second_name']))

										{

											$t[$detail] .= ' '.$t['owner']['passport_second_name'];

										}

										$t[$detail] .= ' '.$t['owner']['passport_last_name'].'</a>';

											

										if($t['tracking_owner_passport'] == 1)

										{

											$t[$detail] .= '</a>';

										}

									}

									echo '<p'; if($i % 2) {echo ' class="bg"';} echo '>'.$tracking[$detail].'<span>'.$t[$detail].'</span></p>';

								}

							}

							if($t['property_type'] == 0)

							{

								echo '<p'; if($i % 2) {echo ' class=""';} echo '>Property price<span>'.$t['property_price'].' &euro;</span></p>';

							}

							else

							{

								echo '<p'; if($i % 2) {echo ' class=""';} echo '>Rent / Month<span>'.$t['property_rent'].'</span></p>';

							}

							?>

						</td>

					</tr>

					<tr>

						<td class="b0 p8" colspan="2"><br /><b><?php

						if($t['property_type'] == 0)

						{

							echo $tracking['track_agent_engaged_for_sale'];

						}

						else

						{

							echo $tracking['track_agent_engaged_for_rent'];

						}

						?> <a href="../?p=<?php echo $t['property_tracking']; ?>&amp;pn=<?php echo str_replace(' ','-',$t['property_name']); ?>" target="_blank"><?php echo $t['property_name'] ?></a></b></td>

					</tr>

					<tr>

						<td class="p5 agent" colspan="2">

						<p><img src="<?php echo $t['agent_image']; ?>" /></p>

						<p>

							<span><b><?php echo $tracking['track_agent_name']; ?></b> <?php echo $t['agent_name']; ?><a href="mailto:<?php echo str_replace(' ','.',$t['agent_name']).'@'.$domain; ?>"><?php echo str_replace(' ','.',$t['agent_name']).'@'.$domain; ?></a></span>

							<?php

								$agent_first_name = explode(' ',$t['agent_name'])[0];

								$agent_last_name = implode(' ',array_diff(explode(' ',$t['agent_name']),array(explode(' ',$t['agent_name'])[0])));

								echo str_replace('agent_last_name',$agent_last_name,str_replace('agent_first_name',$agent_first_name,replace_settings(nl2br($t['agent_description']))));

							?>

						</p>

						<?php if(strlen($t['agent_description']) > 400)

						{

							echo '<span class="no-select read-more"><img src="/f/arrow-down.png" />'.$tracking['track_agent_read_more'].'</span>';

						}

						?>

						</td>

					</tr>

					<tr>

						<td class="b0 p8"><br /><b><?php echo $tracking['track_customer_title']; ?></b></td>

						<td class="b0 p8"><br /><b><?php

						if($s['s_account_type'] == 'cc')

						{

							echo $tracking['track_credit_card_reservation'];

						}

						elseif($t['property_type'] == 0)

						{

							echo $tracking['track_earnest_deposit_sell'];

						}

						else

						{

							echo $tracking['track_earnest_deposit_rent'];

						}

						?></b></td>

					</tr>

					<tr>

						<td valign="top" class="p8 details">

							<?php

								echo '<p class="bg">'.$tracking['track_customer_first_name'].' <span>'.$t['tracking_first_name'].'</span></p>';

								echo '<p>'.$tracking['track_customer_last_name'].' <span>'.$t['tracking_last_name'].'</span></p>';

								echo '<p class="bg">'.$tracking['track_customer_company'].' <span>'.$t['tracking_company'].'</span></p>';

								echo '<p>'.$tracking['track_customer_address'].' <span>'.$t['tracking_address'].'</span></p>';

								echo '<p class="bg">'.$tracking['track_customer_city'].' <span>'.$t['tracking_city'].'</span></p>';

								echo '<p>'.$tracking['track_customer_postal_code'].' <span>'.$t['tracking_postal_code'].'</span></p>';

								echo '<p class="bg">'.$tracking['track_customer_country'].' <span>'.$t['tracking_country'].'</span></p>';

								echo '<p>'.$tracking['track_customer_phone'].' <span>'.$t['tracking_phone'].'</span></p>';

							?>

						</td>

						<?php

							if($s['s_account_type'] == 'text')

							{

								echo '<td valign="top" class="p8">';

								if($t['property_type'] == 0)

								{

									echo nl2br(replace_settings($tracking['track_account_sale_text']));

								}

								else

								{

									echo nl2br(replace_settings($tracking['track_account_rent_text']));

								}

								echo '</td>';

							}

							elseif($s['s_account_type'] == 'details')

							{

								echo '<td valign="top" class="p8 details">';

								$account_array = array('s_account_bank','s_account_holder','s_account_number','s_account_iban','s_account_swift','s_account_country','s_account_address');

								$i = 0;

								foreach($account_array as $field)

								{

									$i++;

									echo '<p'; if($i % 2) {echo ' class="bg"';} echo '>';

									echo $tracking[str_replace('s_','track_',$field)];

									echo '<span>'.$s[$field].'</span>';

									echo '</p>';

								}

								if($t['property_type'] == 0)

								{

									echo '<p>'.$tracking['track_account_earnest_deposit'].' <span>'.$t['property_detail_earnest_procent'].'% - '.$t['property_detail_earnest_deposit'].' &euro;</span></p>';

								}

								else

								{

									echo '<p>'.$tracking['track_account_deposit'].' <span>'.$t['property_deposit'].'</span></p>';

								}

								echo '</td>';

							}

							elseif($s['s_account_type'] == 'cc')

							{

								echo '<td valign="top" class="p8 cc">';

									require_once 'cc_status.php';

								echo '</td>';

							}

						?>

					</tr>

				</table>

				

				<?php

				if(str_replace(' ','',$tracking['track_payment_sale_decription']) != '' && $t['property_type'] == 0)

				{

					echo '

					<br /><table cellspacing="0" cellpadding="0" class="emd" style="border-bottom:1px solid silver; width:100%;">

						<tr>

							<td class="p8">'.nl2br(replace_settings($tracking['track_payment_sale_decription'])).'</td>

						</tr>

					</table>';

				}

				elseif(str_replace(' ','',$tracking['track_payment_rent_decription']) != '' && $t['property_type'] == 1)

				{

					echo '

					<br /><table cellspacing="0" cellpadding="0" class="emd" style="border-bottom:1px solid silver; width:100%;">

						<tr>

							<td class="p8">'.nl2br(replace_settings($tracking['track_payment_rent_decription'])).'</td>

						</tr>

					</table>';

				}

				?>

				

				<br /><b class="p8" style="display:block;"><?php echo $tracking['track_transactions_title'] ?></b>

				<table cellspacing="0" cellpadding="0" class="emd-transactions">

					<tr>

						<th><?php echo $tracking['track_transaction_date'] ?></th>

						<th><?php echo $tracking['track_transaction_payment_method'] ?></th>

						<th><?php echo $tracking['track_transaction_id'] ?></th>

						<th><?php echo $tracking['track_transaction_total_payment'] ?></th>

						<th><?php echo $tracking['track_transaction_status'] ?></th>

					</tr>

					<tr<?php

					if($t['tracking_status'] == 'Completed') {echo ' style="background:#ebfff0"';}

					elseif($t['tracking_status'] == 'Processing') {echo ' style="background:#fff8ea"';}

					elseif($t['tracking_status'] == 'Pending') {echo ' style="background:#fff7f7"';}

					?>>

						<td align="center"><?php echo date("d F o",(14).$_GET['reserve']) ?></td>

						<td align="center"><?php

						if($s['s_account_type'] == 'cc')

						{

							echo $tracking['track_transaction_payment_2_text'];

						}

						else

						{

							echo $tracking['track_transaction_payment_1_text'];

						}

						?></td>

						<td align="center">T<?php echo $_GET['reserve'] ?></td>

						<td align="center"><?php

						if($t['property_type'] == 0)

						{

							echo $t['property_detail_earnest_deposit'].' &euro;';

						}

						else

						{

							$deposit = explode(' ',$t['property_deposit']);

							echo $deposit[0].' &euro;';

						}

						?></td>

						<td align="center"><?php echo $t['tracking_status'] ?></td>

					</tr>

				</table>

				

				<br /><b class="p8" style="display:block;"><?php echo $tracking['track_contact_title'] ?></b>

				<table cellspacing="0" cellpadding="0" class="emd-footer">

					<tr>

						<?php

							foreach($address as $field)

							{

								echo '<td valign="top" class="p8" width="'.(100 / count($address)).'%">'.$field.'</td>';

							}

						?>

					</tr>

				</table>

				<table cellspacing="0" cellpadding="0" class="emd-footer" style="border-top:1px solid silver;">

					<tr>

						<td class="p8"><?php echo $tracking['track_contact_phone'] ?> <?php echo $s['s_phone']; ?> &nbsp;/&nbsp; <?php echo $tracking['track_contact_fax'] ?> <?php echo $s['s_phone']; ?></td>

						<td align="right"><?php echo $tracking['track_contact_form'] ?> <a href="../contact-us/" target="_blank">www.<?php echo $domain; ?>/contact-us</a></td>

					</tr>

				</table>

				

			</div>

			

			<br />

			<div class="center">

				<?php

				echo '<a href="../">'.$tracking['track_link_back'].'</a> &nbsp;';

				if($s['s_account_type'] != 'cc')

				{

					echo ' | &nbsp; <a href="../" onclick="'."$('div.download').fadeIn(); return false;".'">'.$tracking['track_link_download'].'</a>';

				}

				?>

			</div>

		</div>

	<?php

	}

	else

	{

		if(isset($_GET['part']) && ($_GET['part'] == 4 || $_GET['part'] == 5))

		{

			echo $tracking['agreement_owner'];

		}

		else

		{

			if($t['property_type'] == 0)

			{

				echo $tracking['agreement_sale'];

			}

			else

			{

				echo $tracking['agreement_rent'];

			}

			

			if(!isset($_GET['part']) || $_GET['part'] == 3)

			{

				echo '<br /><br /><br /><br />';

				echo '<p class="cepi"><b>CEPI*</b> - <a href="http://www.cepi.eu" target="_blank">http://www.cepi.eu</a> - European Council of Real Estate</p>';

				echo '<br /><br /><br /><br />';

			}

			if(isset($_GET['part']) && $_GET['part'] == 3)

			{

				echo '<br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br />';

			}

		}

	}

	?>

	

	<div id="act" class="no-select">

		<p></p>

		<div class="r10" style="background:#fff url(/t/<?php echo $t['owner_id']; ?>.png) no-repeat top center;"></div>

		<b class="r3 no-select">Close</b>

	</div>

</body>

</html>